<?php
require_once 'database.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];

    // Validate email
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Generate a unique token
        $token = bin2hex(random_bytes(50));

        // Store the token in the password_resets table
        $stmt = $conn->prepare("INSERT INTO password_resets (email, token) VALUES (?, ?)");
        $stmt->bind_param("ss", $email, $token);
        $stmt->execute();

        // Send the password reset link
        $reset_link = "http://" . $_SERVER['HTTP_HOST'] . "/reset_password.php?token=" . $token;

        $curl = curl_init();

        // IMPORTANT: Replace YOUR_DOMAIN and YOUR_SEND_MAIL_TOKEN with your actual credentials
        $post_fields = json_encode([
            "from" => ["address" => "YOUR_DOMAIN"],
            "to" => [["email_address" => ["address" => $email, "name" => "NOH"]]],
            "subject" => "Password Reset Request",
            "htmlbody" => "<div><b>Click on this link to reset your password: <a href='" . $reset_link . "'>" . $reset_link . "</a></b></div>",
        ]);

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.zeptomail.com/v1.1/email",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $post_fields,
            CURLOPT_HTTPHEADER => array(
                "accept: application/json",
                "authorization: YOUR_SEND_MAIL_TOKEN",
                "cache-control: no-cache",
                "content-type: application/json",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            $error = "Failed to send email. cURL Error: " . $err;
        } else {
            // You might want to check the $response from ZeptoMail to ensure it was successful
            $message = "A password reset link has been sent to your email address.";
        }
    } else {
        $error = "No user found with that email address.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - UTME Application</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <img src="img/main.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
    </header>
    <div class="container">
        <h2>Forgot Password</h2>
        <?php if (isset($message)): ?>
            <p><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if (isset($error)): ?>
            <p style="color:red;"><?php echo $error; ?></p>
        <?php endif; ?>
    </div>
</body>
</html>
