<?php
require_once 'database.php';

$error = '';
$message = '';
$token_valid = false;

if (isset($_GET['token'])) {
    $token = $_GET['token'];

    // Validate the token
    $stmt = $conn->prepare("SELECT email FROM password_resets WHERE token = ? AND created_at > NOW() - INTERVAL 1 HOUR");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $token_valid = true;
        $row = $result->fetch_assoc();
        $email = $row['email'];
    } else {
        $error = "Invalid or expired token.";
    }
} else {
    $error = "No token provided.";
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && $token_valid) {
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];

    if ($password === $password_confirm) {
        // Hash the new password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Update the user's password
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE email = ?");
        $stmt->bind_param("ss", $hashed_password, $email);
        
        if ($stmt->execute()) {
            // Delete the token from the password_resets table
            $stmt = $conn->prepare("DELETE FROM password_resets WHERE email = ?");
            $stmt->bind_param("s", $email);
            $stmt->execute();

            $message = "Your password has been reset successfully. You can now <a href='login.php'>login</a>.";
        } else {
            $error = "Failed to reset password. Please try again.";
        }
    } else {
        $error = "Passwords do not match.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - UTME Application</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <img src="img/main.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
    </header>
    <div class="container">
        <h2>Reset Password</h2>
        <?php if ($message): ?>
            <p><?php echo $message; ?></p>
        <?php else: ?>
            <?php if ($error): ?>
                <p style="color:red;"><?php echo $error; ?></p>
            <?php endif; ?>
            <?php if ($token_valid): ?>
                <form method="post" action="reset_password.php?token=<?php echo htmlspecialchars($token); ?>">
                    <div class="form-group">
                        <label for="password">New Password</label>
                        <input type="password" name="password" id="password" placeholder="Enter new password" required>
                    </div>
                    <div class="form-group">
                        <label for="password_confirm">Confirm New Password</label>
                        <input type="password" name="password_confirm" id="password_confirm" placeholder="Confirm new password" required>
                    </div>
                    <input type="submit" value="Reset Password">
                </form>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>
