<?php
require_once 'database.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $firstname = $_POST['firstname'];
    $lastname = $_POST['lastname'];
    $email = $_POST['email'];
    $phonenumber = $_POST['phonenumber'];
    $school = $_POST['school'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // Check if email already exists
    $sql = "SELECT id FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $error = "This email is already registered.";
    } else {
        $sql = "INSERT INTO users (firstname, lastname, email, phonenumber, school, password) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssss", $firstname, $lastname, $email, $phonenumber, $school, $password);

        if ($stmt->execute()) {
            $user_id = $stmt->insert_id;
            $application_no = "NOHIL/".$school."/".date('y')."/".str_pad($user_id, 6, '0', STR_PAD_LEFT);

            $sql_app = "INSERT INTO applications (user_id, application_no, status) VALUES (?, ?, 'pending')";
            $stmt_app = $conn->prepare($sql_app);
            $stmt_app->bind_param("is", $user_id, $application_no);
            $stmt_app->execute();

            header("Location: login.php?registration=success");
        } else {
            $error = "Error: " . $stmt->error;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <script src="main.js"></script>
</head>
<body>
    <?php if (isset($error)): ?>
        <script>showAlert('<?php echo $error; ?>');</script>
    <?php endif; ?>
    <header>
        <img src="img/main.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
    </header>
    <div class="container">
        <h2>Create Account</h2>
        <form method="post" action="register.php">
            <input type="text" name="firstname" placeholder="First Name" required>
            <input type="text" name="lastname" placeholder="Last Name" required>
            <input type="email" name="email" placeholder="Email" required>
            <input type="tel" name="phonenumber" placeholder="Phone Number" required>
            <input type="password" name="password" placeholder="Password" required>
            <input type="hidden" name="school" id="school_hidden">
            <input type="submit" value="Register">
        </form>
        <p>Already have an account? <a href="login.php">Login here</a>.</p>
        <p><a href="index.php">Back to Homepage</a></p>
    </div>
    <script>
        const urlParams = new URLSearchParams(window.location.search);
        const school = urlParams.get('school') || 'cns';
        document.getElementById('logo').src = 'img/' + school + '.jpeg';
        document.getElementById('school_hidden').value = school;
    </script>
</body>
</html>
