<?php
ob_start();
session_start();
require('database.php');

if (!isset($_SESSION['id'])) {
    header('Location: login.php');
    exit();
}

$id = $_SESSION['id'];

// Generate RRR via Remita API
// Retrieve user details for RRR generation
$userQuery = "SELECT firstname, lastname, email, phonenumber FROM users WHERE id = ?";
$stmt = $conn->prepare($userQuery);
$stmt->bind_param("s", $id);
$stmt->execute();
$userResult = $stmt->get_result();

if ($userResult && $userRow = $userResult->fetch_assoc()) {
    $name = $userRow['firstname'] . ' ' . $userRow['lastname'];
    $email = $userRow['email'];
    $phone = $userRow['phonenumber'];
} else {
    die("User not found.");
}

//demo parameter
$merchantId = '2547916';
$apiKey = '1946';
$serviceTypeId = '4430731';
$orderId = $id.time();
$description = 'POST UTME Application Fee';
$amount = 17000;

$apiHash = hash('sha512', $merchantId . $serviceTypeId . $orderId . $amount . $apiKey);

$requestData = array(
    'serviceTypeId' => $serviceTypeId,
    'amount' => $amount,
    'orderId' => $orderId,
    'payerName' => $name,
    'payerEmail' => $email,
    'payerPhone' => $phone,
    'description' => $description,
);

$authorizationHeader = 'remitaConsumerKey=' . $merchantId . ',remitaConsumerToken=' . $apiHash;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://demo.remita.net/remita/exapp/api/v1/send/api/echannelsvc/merchant/api/paymentinit');
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Authorization: ' . $authorizationHeader
));

$response = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo 'Error: ' . $error;
    exit();
}

// Remove JSONP padding
$response = trim($response);
if (strpos($response, 'jsonp (') === 0) {
    $response = substr($response, 7, -1); // Remove 'jsonp (' from the start and ')' from the end
}

// Attempt to decode the JSON data
$responseData = json_decode($response, true);

if (isset($responseData['statuscode']) && $responseData['statuscode'] === '025') {
    $rrr = $responseData['RRR'];
    
    $sql = "UPDATE applications SET rrr=?, reference=? WHERE user_id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sss", $rrr, $orderId, $id);
    
    if($stmt->execute()){
        $sql_app = "SELECT application_no FROM applications WHERE user_id = ?";
        $stmt_app = $conn->prepare($sql_app);
        $stmt_app->bind_param("s", $id);
        $stmt_app->execute();
        $result_app = $stmt_app->get_result();

        if ($result_app && $result_app->num_rows > 0) {
            $app_data = $result_app->fetch_assoc();
            header('Location: paynow.php?AppNo=' . $app_data['application_no']);
        } else {
            echo "Error: Could not retrieve application number after update.";
        }
    } else {
        echo "Error updating record: " . $stmt->error;
    }
} else {
    echo "Error generating RRR: " . $response;
}
?>
