<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];

// Fetch all user data
$user_data = [];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $user_data = $result->fetch_assoc();
}
$stmt->close();

// Fetch application data
$application_data = [];
$stmt = $conn->prepare("SELECT * FROM applications WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $application_data = $result->fetch_assoc();
}
$stmt->close();

// Fetch O-Level results
$olevel_results = [];
$stmt = $conn->prepare("SELECT * FROM olevel_results WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $olevel_results[] = $row;
}
$stmt->close();

// Fetch education details
$education_details = [];
$stmt = $conn->prepare("SELECT * FROM education_details WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $education_details[] = $row;
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Application - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            .print-container, .print-container * {
                visibility: visible;
            }
            .print-container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="print-container">
        <header>
            <img src="img/main.jpeg" alt="School Logo">
            <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
        </header>
        <div class="container">
            <h2>Submission Details</h2>
            <div class="personal-info">
                <div class="profile-image">
                    <?php if (!empty($user_data['passport_photo'])): ?>
                        <img src="<?php echo htmlspecialchars($user_data['passport_photo']); ?>" style="width: 150px; height: 150px; object-fit: cover;" alt="User">
                    <?php else: ?>
                        <p>No Picture Uploaded</p>
                    <?php endif; ?>
                </div>
                <div class="user-details">
                    <p><strong>Full Name:</strong> <?php echo htmlspecialchars($user_data['firstname'] . ' ' . $user_data['lastname'] . ' ' . $user_data['othername']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($user_data['email']); ?></p>
                    <p><strong>Phone Number:</strong> <?php echo htmlspecialchars($user_data['phonenumber']); ?></p>
                    <p><strong>Application Number:</strong> <?php echo htmlspecialchars($application_data['application_no']); ?></p>
                    <p><strong>Programme:</strong> <?php echo htmlspecialchars($user_data['programme']); ?></p>
                    <p><strong>Jamb Score:</strong> <?php echo htmlspecialchars($user_data['jambscore']); ?></p>
                    <p><strong>Jamb Number:</strong> <?php echo htmlspecialchars($user_data['jambnumber']); ?></p>
                    <p><strong>School:</strong> <?php echo htmlspecialchars($user_data['school']); ?></p>
                    <p><strong>Session:</strong> <?php echo htmlspecialchars($user_data['session']); ?></p>
                    <p><strong>Gender:</strong> <?php echo htmlspecialchars($user_data['gender']); ?></p>
                    <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($user_data['dob']); ?></p>
                    <p><strong>Disability:</strong> <?php echo htmlspecialchars($user_data['disability']); ?></p>
                    <p><strong>Place of Birth:</strong> <?php echo htmlspecialchars($user_data['placeOfBirth']); ?></p>
                    <p><strong>State of Origin:</strong> <?php echo htmlspecialchars($user_data['stateOfOrigin']); ?></p>
                    <p><strong>LGA:</strong> <?php echo htmlspecialchars($user_data['lga']); ?></p>
                    <p><strong>Home Address:</strong> <?php echo htmlspecialchars($user_data['homeAddress']); ?></p>
                    <p><strong>Next of Kin Name:</strong> <?php echo htmlspecialchars($user_data['nextOfKinName']); ?></p>
                    <p><strong>Next of Kin GSM Number:</strong> <?php echo htmlspecialchars($user_data['nextOfKinGsm']); ?></p>
                    <p><strong>Next of Kin Address:</strong> <?php echo htmlspecialchars($user_data['nextOfKinAddress']); ?></p>
                    <p><strong>Sponsor's Name:</strong> <?php echo htmlspecialchars($user_data['sponsorName']); ?></p>
                    <p><strong>Sponsor's Address:</strong> <?php echo htmlspecialchars($user_data['sponsorAddress']); ?></p>
                </div>
            </div>

            <h2>Education Details</h2>
            <?php if (!empty($education_details)): ?>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Institution Name</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Qualification</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($education_details as $index => $detail): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo htmlspecialchars($detail['institution_name']); ?></td>
                                <td><?php echo htmlspecialchars($detail['from_date']); ?></td>
                                <td><?php echo htmlspecialchars($detail['to_date']); ?></td>
                                <td><?php echo htmlspecialchars($detail['qualification']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>No education details provided.</p>
            <?php endif; ?>

            <h2>O-Level Results</h2>
            <?php if (!empty($olevel_results)): ?>
                <?php foreach ($olevel_results as $result): ?>
                    <div class="olevel-results-container">
                        <h3><?php echo htmlspecialchars($result['sitting']); ?> Sitting</h3>
                        <table>
                            <tbody>
                                <tr>
                                    <td><strong>Year:</strong> <?php echo htmlspecialchars($result['year']); ?></td>
                                    <td><strong>Exam Body:</strong> <?php echo htmlspecialchars($result['exam_body']); ?></td>
                                    <td><strong>Exam Type:</strong> <?php echo htmlspecialchars($result['exam_type']); ?></td>
                                    <td><strong>Exam No:</strong> <?php echo htmlspecialchars($result['exam_no']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                        <table>
                            <thead>
                                <tr>
                                    <th>Subject</th>
                                    <th>Grade</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $subjects = ['math', 'english', 'biology', 'chemistry', 'physics', 'geography', 'economics', 'government', 'literature'];
                                foreach ($subjects as $subject) {
                                    if (!empty($result[$subject . '_grade'])) {
                                        echo "<tr><td>" . ucfirst($subject) . "</td><td>" . htmlspecialchars($result[$subject . '_grade']) . "</td></tr>";
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>No O-Level results provided.</p>
            <?php endif; ?>

            <p><strong>NOTE:</strong> Photocopies of all the statement of results, certificates, etc MUST accompany this form as a condition for consideration of admission</p>
            <h2>Declaration</h2>
            <p>I, <?php echo htmlspecialchars($user_data['firstname'] . ' ' . $user_data['lastname'] . ' ' . $user_data['othername']); ?> hereby declare that the information given above is genuine and accurate.</p>
            <p class="sign">Sign & Date _______________________</p>
            <h2>For Official Use Only</h2>
            <p class="sign">Screening Officer Sign & Date _______________________</p>
        </div>
    </div>
    <div class="no-print" style="text-align: center; margin-top: 20px;">
        <button onclick="window.print()" class="btn-custom">Print</button>
        <a href="dashboard.php" class="btn-custom">Back to Dashboard</a>
    </div>
</body>
</html>
