<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];

// Get user data
$sql = "SELECT * FROM users LEFT JOIN applications ON users.id = applications.user_id WHERE users.id = $userid";
$result = $conn->query($sql);
$user_data = $result->fetch_assoc();

// Get olevel results
$sql = "SELECT * FROM olevel_results WHERE user_id = $userid";
$result = $conn->query($sql);
$olevel_data = [];
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $olevel_data[$row['sitting']] = $row;
    }
}

// Get education details
$sql = "SELECT * FROM education_details WHERE user_id = $userid";
$result = $conn->query($sql);
$education_details = [];
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $education_details[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Preview - UTME Application</title>
    <link rel="stylesheet" href="preview.css">
</head>

<body>
    <header class="header">
        <div class="header-inner">
            <img src="img/<?php echo $_SESSION['school']; ?>.jpeg" alt="School Logo" id="logo" class="logo">
            <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
            <p>Application Number: <?php echo $user_data['application_no']; ?> | School: <?php echo $user_data['school']; ?></p>
        </div>
    </header>
    <div id="a4-preview" class="a4-preview">
        <h2>Application Preview</h2>

        <h3>Personal Details</h3>
        <table class="details-table">
            <tr>
                <th>Passport Photo</th>
                <td colspan="5">
                    <?php if (!empty($user_data['passport_photo'])): ?>
                        <img src="<?php echo $user_data['passport_photo']; ?>" alt="Passport Photo" width="100" class="passport-photo">
                    <?php endif; ?>
                </td>
            </tr>
            <?php
            // Define fields and labels
            $fields = [
                'firstname' => 'First Name',
                'lastname' => 'Last Name',
                'othername' => 'Other Name',
                'gender' => 'Gender',
                'dob' => 'Date of Birth',
                'disability' => 'Disability',
                'placeOfBirth' => 'Place of Birth',
                'stateOfOrigin' => 'State of Origin',
                'lga' => 'LGA',
                'email' => 'Email',
                'phonenumber' => 'Phone Number',
                'homeAddress' => 'Home Address',
                'nextOfKinName' => 'Next of Kin Name',
                'nextOfKinGsm' => 'Next of Kin GSM',
                'nextOfKinAddress' => 'Next of Kin Address',
                'sponsorName' => 'Sponsor Name',
                'sponsorAddress' => 'Sponsor Address',
                'jambnumber' => 'JAMB Number',
                'jambscore' => 'JAMB Score',
                'school' => 'School',
                'programme' => 'Programme',
                'session' => 'Session'
            ];
            $field_keys = array_keys($fields);
            $total = count($field_keys);
            for ($i = 0; $i < $total; $i += 2) {
                echo "<tr>";
                for ($j = 0; $j < 2; $j++) {
                    $idx = $i + $j;
                    if ($idx < $total) {
                        $key = $field_keys[$idx];
                        $label = $fields[$key];
                        $value = isset($user_data[$key]) ? $user_data[$key] : '';
                        echo "<th>$label</th>";
                        echo "<td>$value</td>";
                    } else {
                        // Fill empty cells if not enough fields
                        echo "<th></th><td></td>";
                    }
                }
                echo "</tr>";
            }
            ?>
        </table>

        <h3>O'Level Results</h3>
        <?php foreach ($olevel_data as $sitting => $data): ?>
            <h4>Sitting <?php echo $sitting; ?></h4>
            <table class="olevel-table">
                <tr><th>Year</th><td><?php echo $data['year']; ?></td></tr>
                <tr><th>Exam Body</th><td><?php echo $data['exam_body']; ?></td></tr>
                <tr><th>Exam Type</th><td><?php echo $data['exam_type']; ?></td></tr>
                <tr><th>Exam No</th><td><?php echo $data['exam_no']; ?></td></tr>
                <tr><th>Subjects & Grades</th><td>
                    <table class="subjects-table">
                        <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Grade</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        // Dynamically show all subjects and grades for this sitting
                        foreach ($data as $key => $value) {
                            if (preg_match('/^(.*)_grade$/', $key, $matches) && ($value !== '' && $value !== null)) {
                                $subjectName = ucwords(str_replace('_', ' ', $matches[1]));
                                echo "<tr><td>$subjectName</td><td>$value</td></tr>";
                            }
                        }
                        ?>
                        </tbody>
                    </table>
                </td></tr>
            </table>
        <?php endforeach; ?>

        <h3>Educational Details</h3>
        <table class="education-table">
            <thead>
                <tr>
                    <th>Institution Name</th>
                    <th>From</th>
                    <th>To</th>
                    <th>Qualification</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($education_details as $detail): ?>
                    <tr>
                        <td><?php echo $detail['institution_name']; ?></td>
                        <td><?php echo $detail['from_date']; ?></td>
                        <td><?php echo $detail['to_date']; ?></td>
                        <td><?php echo $detail['qualification']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div class="footer-links">
            <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
            <a href="process_payment.php?AppNo=<?php echo $user_data['application_no']; ?>" class="btn">Pay Now</a>
        </div>
    </div>
</body>
</html>
