<!DOCTYPE html>
<html lang="en">
<head>
    <?php
    // Start PHP session
    session_start();

    // Initialize variables
    $applicantNo = '';
    $rrr = '';
    $status = '';
    $error = '';

    // Database connection parameters
    $db_host = 'localhost';      // Replace with your database host
    $db_user = 'root';  // Replace with your database username
    $db_pass = '';  // Replace with your database password
    $db_name = 'utme_db';  // Replace with your database name

    // Check if AppNo parameter is set in the URL
if (isset($_GET['AppNo'])) {
    $applicantNo = $_GET['AppNo'];

    // Create database connection
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

    // Check connection
    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    } else {
        // Prepare and execute query to fetch RRR and status
        $stmt = $conn->prepare("SELECT rrr, status FROM applications WHERE application_no = ?");
        
        // Check if the statement was prepared successfully
        if ($stmt === false) {
            die("Error preparing statement: " . $conn->error);
        }

        // Bind the parameter and execute
        $stmt->bind_param("s", $applicantNo);
        $stmt->execute();
        $stmt->bind_result($rrr, $status);
        $stmt->fetch();
        $stmt->close();
        $conn->close();

        // Check if RRR was found
        if (empty($rrr)) {
            die("No RRR found for Application Number: " . htmlspecialchars($applicantNo));
        }
    }
} else {
    die("No Application Number provided in the URL.");
}
    ?>
    <title>Remita Payment Processing</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom Styles -->
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .payment-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .logo {
            max-width: 100px;
            margin: 0 20px;
        }
        .logos-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 30px;
        }
        .btn-custom {
            background-color: #1CA78B;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            width: 100%;
            margin-top: 20px;
        }
        .btn-custom:hover {
            background-color: #17907a;
        }
        .error-message {
            color: #dc3545;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="logos-container">
            <!-- Replace 'logo1.png' and 'logo2.png' with your actual logo paths -->
            <img src="img/main.jpeg" alt="Logo 1" class="logo">
            <img src="img/remita.png" alt="Logo 2" class="logo">
        </div>
        <h2 class="mb-4">Remita Payment Processing</h2>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error; ?>
            </div>
        <?php else: ?>
            <p class="mb-4">Processing payment for Application Number: <strong><?php echo htmlspecialchars($applicantNo); ?></strong></p>
            <form id="payment-form">
                <div class="form-floating mb-4">
                    <input type="text" class="form-control" id="js-rrr" placeholder="Enter RRR" value="<?php echo htmlspecialchars($rrr); ?>" readonly>
                    <label for="js-rrr">Payment Reference (RRR)</label>
                </div>
                <button type="button" onclick="makePayment()" class="btn btn-custom" <?php if ($status === 'completed') echo 'disabled'; ?>>
                    <?php echo ($status === 'completed') ? 'Payment Successful' : 'Pay Now'; ?>
                </button>
                <a href="index.php" class="btn btn-secondary mt-3" onclick="return confirm('Are you sure you want to go back to the homepage?');">Back to Home</a>
            </form>
        <?php endif; ?>
    </div>

    <!-- Remita Payment Script -->
    <script type="text/javascript" src="https://remitademo.net/payment/v1/remita-pay-inline.bundle.js"></script>

    <script>
        function makePayment() {
            const rrr = document.getElementById("js-rrr").value;

            if (!rrr) {
                alert("RRR is missing.");
                return;
            }
            var randomnumber = Math.floor(Math.random() * 1101233); // Removed the unnecessary backslash
            var paymentEngine = RmPaymentEngine.init({
            key: "QzAwMDAyNzEyNTl8MTEwNjE4NjF8OWZjOWYwNmMyZDk3MDRhYWM3YThiOThlNTNjZTE3ZjYxOTY5NDdmZWE1YzU3NDc0ZjE2ZDZjNTg1YWYxNWY3NWM4ZjMzNzZhNjNhZWZlOWQwNmJhNTFkMjIxYTRiMjYzZDkzNGQ3NTUxNDIxYWNlOGY4ZWEyODY3ZjlhNGUwYTY=",
            processRrr: true,
            transactionId: randomnumber.toString(), // Generate a unique transactionId
            channel: "CARD,USSD,TRANSFER,BANK,BRANCH,IBANK,PAYWITHREMITA", // Filter card channels for the payment modal
            extendedData: {
                customFields: [
                    {
                        name: "rrr",
                        value: rrr // RRR to be processed
                    }
                ]
            },
            onSuccess: function (response) {
                console.log('Callback Successful Response', response);
                window.location.href = 'payment_success.php?rrr=' + response.rrr + '&transactionId=' + response.transactionId;
            },
            onError: function (response) {
                console.log('Callback Error Response', response);
            },
            onClose: function () {
                console.log("Payment widget closed");
            }
        });
            paymentEngine.showPaymentWidget();
        }
    </script>
    <!-- Bootstrap JS CDN -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
