<!DOCTYPE html>
<html lang="en">
<head>
    <?php
    session_start();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
    // Check if session variables are set
require_once 'database.php';

// Check if user is logged in and rrr is provided
if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit;
}
if (!isset($_GET['rrr'])) {
    die("Missing payment details. Please try again.");
}

// Fetch values
$rrr = $_GET['rrr'];
$userid = $_SESSION['id'];

// Get applicant number for display
$application_no = 'N/A';
$stmt_app = $conn->prepare("SELECT application_no FROM applications WHERE user_id = ?");
if ($stmt_app) {
    $stmt_app->bind_param("i", $userid);
    $stmt_app->execute();
    $result_app = $stmt_app->get_result();
    if ($result_app && $result_app->num_rows > 0) {
        $app_data = $result_app->fetch_assoc();
        $application_no = $app_data['application_no'];
    }
    $stmt_app->close();
}

    // Define your credentials and data
   //demo parameter
    $merchantId = '2547916';
    $apiKey = '1946';
    $serviceTypeId = '4430731';
    $orderId = $application_no.time();
    $description = 'POST UTME Application Fee';
    $amount=17000;
// live parameter 
    // $merchantId = '2561485553';
    // $apiKey = '485130';
    // $serviceTypeId = '591169797';
    // $orderId = $user_id.time();
    // $description = 'Remote Appointment Fee';
    // $amount=4200;

    // Generate the API hash
    $apiHash = hash('sha512', $rrr . $apiKey . $merchantId );

    // Build the URL
   $url = 'https://demo.remita.net/remita/exapp/api/v1/send/api/echannelsvc/'.$merchantId.'/'. $rrr .'/'.$apiHash .'/status.reg';
    //   $url = 'https://login.remita.net/remita/exapp/api/v1/send/api/echannelsvc/'.$merchantId.'/'. $rrr .'/'.$apiHash .'/status.reg';

   $authorizationHeader = 'remitaConsumerKey=' . $merchantId . ',remitaConsumerToken=' . $apiHash;
    // Set up the cURL request
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($ch, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json ',
        
    ));

    // Send the request and handle the response
    $response = curl_exec($ch);
    $error = curl_error($ch);

    curl_close($ch);

    $status = "error";
    $message = "";

if ($error) {
    $message = "cURL Error: " . $error;
} else {
    $response = trim($response);
    if (strpos($response, 'jsonp (') === 0) {
        $response = substr($response, 7, -1); // Remove 'jsonp (' and ')'
    }

    $responseData = json_decode($response);
    if (isset($responseData->status) && ($responseData->status === '00' || $responseData->status === '01')) {
        // Update the status of the transaction in the database
        $sql = "UPDATE applications SET status = 'completed' WHERE rrr = ? AND user_id = ?";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("si", $rrr, $userid);
            $stmt->execute();
            $stmt->close();
        }
        header("Location: printout.php");
        exit;
    } else if (isset($responseData->message)) {
        $message = $responseData->message;
    } else {
        $message = "Status not found in response. Raw response: " . htmlspecialchars($response);
    }
}
    ?>
    <title>Transaction Status</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .status-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .logo {
            max-width: 100px;
            margin: 0 20px;
        }
        .logos-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 30px;
        }
        .btn-custom {
            background-color: #1CA78B;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            width: 100%;
            margin-top: 20px;
        }
        .btn-custom:hover {
            background-color: #17907a;
        }
    </style>
</head>
<body>
    <div class="status-container">
        <div class="logos-container">
            <img src="img/main.jpeg" alt="Logo 1" class="logo">
            <img src="img/remita.png" alt="Logo 2" class="logo">
        </div>
        <h2 class="mb-4">Transaction Status</h2>

        <p class="mb-4">Application Number: <strong><?php echo htmlspecialchars($application_no); ?></strong></p>
        <!--<p class="mb-4">Transaction Status: <strong><?php //echo htmlspecialchars($status); ?></strong></p>-->
        <?php if (!empty($message)): ?>
            <p class="mb-4">Message: <strong><?php echo htmlspecialchars($message); ?></strong></p>
        <?php endif; ?>

        <a href="dashboard.php" class="btn btn-custom">Dashboard</a>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>