<?php
ob_start();
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?php
   

    $applicantNo = '';
    $rrr = '';
    $error = '';

    if (isset($_SESSION['user_id'])) {
        $applicantNo = $_SESSION['user_id'];
        include('database.php');

        if ($db->connect_error) {
            die("Database connection failed: " . $db->connect_error);
        } else {
            $stmt = $db->prepare("SELECT rrr,reference FROM users WHERE id = ?");
            if ($stmt === false) {
                die("Error preparing statement: " . $db->error);
            }

            $stmt->bind_param("s", $applicantNo);
            $stmt->execute();
            $stmt->bind_result($rrr,$reference);
            $stmt->fetch();
            $stmt->close();
            $db->close();

            if (empty($rrr)) {
                die("No RRR found for Application Number: " . htmlspecialchars($applicantNo));
            } else {
               $_SESSION['applicantNo'] = $applicantNo;
               $_SESSION['rrr'] = $rrr;
               $_SESSION['reference'] = $reference;
            }
        }
    } else {
        die("No Application Number provided in the URL.");
    }
    ?>
    <title>Remita Payment Processing</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .payment-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .logo {
            max-width: 100px;
            margin: 0 20px;
        }
        .logos-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 30px;
        }
        .btn-custom {
            background-color: #1CA78B;
            color: #fff;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            width: 100%;
            margin-top: 20px;
        }
        .btn-custom:hover {
            background-color: #17907a;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="logos-container">
            <img src="img/main.jpeg" alt="Logo 1" class="logo">
            <img src="img/remita.png" alt="Logo 2" class="logo">
        </div>
        <h2 class="mb-4">Remita Payment Processing</h2>

        <p class="mb-4">Processing payment for UTME FORM: <strong><?php echo htmlspecialchars($applicantNo); ?></strong></p>
        <form id="payment-form">
            <div class="form-floating mb-4">
                <input type="text" class="form-control" id="js-rrr" placeholder="Enter RRR" value="<?php echo htmlspecialchars($rrr); ?>" readonly>
                <label for="js-rrr">Payment Reference (RRR)</label>
            </div>
            <button type="button" onclick="makePayment()" class="btn btn-custom">Pay Now</button>
           <a href='dashboard.php'><button type="button"  class="btn btn-danger">Go Back</button></a>
        </form>
    </div>
 <!--<script type="text/javascript" src="https://login.remita.net/payment/v1/remita-pay-inline.bundle.js"></script>-->
    <script type="text/javascript" src="https://demo.remita.net/payment/v1/remita-pay-inline.bundle.js"></script>
    <script>
        function makePayment() {
            const rrr = document.getElementById("js-rrr").value;

            if (!rrr) {
                alert("RRR is missing.");
                return;
            }
            var randomnumber = Math.floor(Math.random() * 1101233);
            var paymentEngine = RmPaymentEngine.init({
                key: "QzAwMDAyNzEyNTl8MTEwNjE4NjF8OWZjOWYwNmMyZDk3MDRhYWM3YThiOThlNTNjZTE3ZjYxOTY5NDdmZWE1YzU3NDc0ZjE2ZDZjNTg1YWYxNWY3NWM4ZjMzNzZhNjNhZWZlOWQwNmJhNTFkMjIxYTRiMjYzZDkzNGQ3NTUxNDIxYWNlOGY4ZWEyODY3ZjlhNGUwYTY=",
                // key: "Tk9ISUx8MjU2MTQ4NTU1M3w5Mzg4NmU5Njc4NzNhY2YzMTI2OTQ3NGIxMjU2MTY2MDBhYzViNzcxNzVhNTQ1NWU1ZTMzYjNmNWI4YjAwMDRhODA4OWRhMmEwNzY1NDcwNGQzOWM0MThlNTA1MTIwODllMmEwYWI2ZDI4M2NjYWFhNjNiZGYzMzRiMGE2Y2UxYQ==",
                processRrr: true,
                transactionId: randomnumber.toString(),
                channel: "CARD,USSD",
                extendedData: {
                    customFields: [
                        {
                            name: "rrr",
                            value: rrr
                        }
                    ]
                },
                onSuccess: function (response) {
                    console.log('Callback Successful Response', response);
                    window.location.href = "payment_success.php";
                },
                onError: function (response) {
                    console.log('Callback Error Response', response);
                },
                onClose: function () {
                    console.log("Payment widget closed");
                }
            });
            paymentEngine.showPaymentWidget();
        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
