<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];
$sql = "SELECT * FROM olevel_results WHERE user_id = $userid";
$result = $conn->query($sql);
if ($result->num_rows > 0 && $_SERVER["REQUEST_METHOD"] != "POST") {
    $olevel_data = [];
    while($row = $result->fetch_assoc()) {
        $olevel_data[$row['sitting']] = $row;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Process first sitting
    if (isset($_POST['first_sitting'])) {
        $sitting = 1;
        $year = $_POST['first_year'];
        $exam_body = $_POST['first_exam_body'];
        $exam_type = $_POST['first_exam_type'];
        $exam_no = $_POST['first_exam_no'];
        
        $grades = [];
        $subjectsList = [
            "math", "english", "biology", "chemistry", "physics", "geography", "economics", "government", "literature",
        ];
        foreach ($subjectsList as $subject) {
            $grades[$subject] = $_POST["first_".$subject."_grade"] ?? '';
        }

        $sql = "DELETE FROM olevel_results WHERE user_id = $userid AND sitting = 1";
        $conn->query($sql);
        $sql = "INSERT INTO olevel_results (user_id, sitting, year, exam_body, exam_type, exam_no, math_grade, english_grade, biology_grade, chemistry_grade, physics_grade, geography_grade, economics_grade, government_grade, literature_grade) VALUES ('$userid', '$sitting', '$year', '$exam_body', '$exam_type', '$exam_no', '{$grades['math']}', '{$grades['english']}', '{$grades['biology']}', '{$grades['chemistry']}', '{$grades['physics']}', '{$grades['geography']}', '{$grades['economics']}', '{$grades['government']}', '{$grades['literature']}')";
        $conn->query($sql);
    }

    // Process second sitting
    if (isset($_POST['second_sitting']) && !empty($_POST['second_year'])) {
        $sitting = 2;
        $year = $_POST['second_year'];
        $exam_body = $_POST['second_exam_body'];
        $exam_type = $_POST['second_exam_type'];
        $exam_no = $_POST['second_exam_no'];

        $grades = [];
        foreach ($subjectsList as $subject) {
            $grades[$subject] = $_POST["second_".$subject."_grade"] ?? '';
        }

        $sql = "DELETE FROM olevel_results WHERE user_id = $userid AND sitting = 2";
        $conn->query($sql);
        $sql = "INSERT INTO olevel_results (user_id, sitting, year, exam_body, exam_type, exam_no, math_grade, english_grade, biology_grade, chemistry_grade, physics_grade, geography_grade, economics_grade, government_grade, literature_grade) VALUES ('$userid', '$sitting', '$year', '$exam_body', '$exam_type', '$exam_no', '{$grades['math']}', '{$grades['english']}', '{$grades['biology']}', '{$grades['chemistry']}', '{$grades['physics']}', '{$grades['geography']}', '{$grades['economics']}', '{$grades['government']}', '{$grades['literature']}')";
        $conn->query($sql);
    }
    header("Location: dashboard.php");
}

$years = ["2020", "2021", "2022", "2023","2024", "2025"];
$examBodies = ["WAEC", "NECO", "GCE"];
$examTypes = ["SSCE", "GCE"];
$subjectsList = [
    "math", "english", "biology", "chemistry", "physics", "geography", "economics", "government", "literature",
];
$gradesList = ["A1", "B2", "B3", "C4", "C5", "C6", "D7", "E8", "F9", "AR"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>O'Level Results - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <script src="main.js"></script>
</head>
<body>
    <header>
        <img src="img/<?php echo $_SESSION['school']; ?>.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
        <?php
            $sql = "SELECT application_no, school FROM applications a JOIN users u ON a.user_id = u.id WHERE u.id = $userid";
            $result = $conn->query($sql);
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                echo "<p>Application Number: <strong>".$row['application_no']."</strong> | School: <strong>".strtoupper($row['school'])."</strong></p>";
            }
        ?>
    </header>
    <div class="container">
        <h2>O'Level Results</h2>
        <form method="post" action="olevel_form.php" class="olevel-form">
            <div class="sitting">
                <h3>First Sitting</h3>
                <input type="hidden" name="first_sitting" value="1">
                <div class="form-group">
                    <label for="first_exam_no">Exam No</label>
                    <input type="text" id="first_exam_no" name="first_exam_no" placeholder="Exam No" value="<?php echo $olevel_data[1]['exam_no'] ?? ''; ?>">
                </div>
                <div class="form-group">
                    <label for="first_year">Year</label>
                    <select id="first_year" name="first_year">
                        <option value="">Select Year</option>
                        <?php foreach ($years as $year): ?>
                            <option value="<?php echo $year; ?>" <?php if(isset($olevel_data[1]) && $olevel_data[1]['year'] == $year) echo 'selected'; ?>><?php echo $year; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="first_exam_body">Exam Body</label>
                    <select id="first_exam_body" name="first_exam_body">
                        <option value="">Select Exam Body</option>
                        <?php foreach ($examBodies as $body): ?>
                            <option value="<?php echo $body; ?>" <?php if(isset($olevel_data[1]) && $olevel_data[1]['exam_body'] == $body) echo 'selected'; ?>><?php echo $body; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="first_exam_type">Exam Type</label>
                    <select id="first_exam_type" name="first_exam_type">
                        <option value="">Select Exam Type</option>
                        <?php foreach ($examTypes as $type): ?>
                            <option value="<?php echo $type; ?>" <?php if(isset($olevel_data[1]) && $olevel_data[1]['exam_type'] == $type) echo 'selected'; ?>><?php echo $type; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php foreach ($subjectsList as $subject): ?>
                    <div class="subject-group">
                        <label for="first_<?php echo $subject; ?>_grade"><?php echo ucfirst($subject); ?></label>
                        <select id="first_<?php echo $subject; ?>_grade" name="first_<?php echo $subject; ?>_grade">
                            <option value="">Select Grade</option>
                            <?php foreach ($gradesList as $grade): ?>
                                <option value="<?php echo $grade; ?>" <?php if(isset($olevel_data[1]) && $olevel_data[1][$subject.'_grade'] == $grade) echo 'selected'; ?>><?php echo $grade; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endforeach; ?>
            </div>

            <button type="button" onclick="showSecondSitting()">Add Second Sitting</button>

            <div class="sitting" id="second_sitting_form" style="display:none;">
                <h3>Second Sitting</h3>
                <input type="hidden" name="second_sitting" value="1">
                <div class="form-group">
                    <label for="second_exam_no">Exam No</label>
                    <input type="text" id="second_exam_no" name="second_exam_no" placeholder="Exam No" value="<?php echo $olevel_data[2]['exam_no'] ?? ''; ?>">
                </div>
                <div class="form-group">
                    <label for="second_year">Year</label>
                    <select id="second_year" name="second_year">
                        <option value="">Select Year</option>
                        <?php foreach ($years as $year): ?>
                            <option value="<?php echo $year; ?>" <?php if(isset($olevel_data[2]) && $olevel_data[2]['year'] == $year) echo 'selected'; ?>><?php echo $year; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="second_exam_body">Exam Body</label>
                    <select id="second_exam_body" name="second_exam_body">
                        <option value="">Select Exam Body</option>
                        <?php foreach ($examBodies as $body): ?>
                            <option value="<?php echo $body; ?>" <?php if(isset($olevel_data[2]) && $olevel_data[2]['exam_body'] == $body) echo 'selected'; ?>><?php echo $body; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="second_exam_type">Exam Type</label>
                    <select id="second_exam_type" name="second_exam_type">
                        <option value="">Select Exam Type</option>
                        <?php foreach ($examTypes as $type): ?>
                            <option value="<?php echo $type; ?>" <?php if(isset($olevel_data[2]) && $olevel_data[2]['exam_type'] == $type) echo 'selected'; ?>><?php echo $type; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php foreach ($subjectsList as $subject): ?>
                    <div class="subject-group">
                        <label for="second_<?php echo $subject; ?>_grade"><?php echo ucfirst($subject); ?></label>
                        <select id="second_<?php echo $subject; ?>_grade" name="second_<?php echo $subject; ?>_grade">
                            <option value="">Select Grade</option>
                            <?php foreach ($gradesList as $grade): ?>
                                <option value="<?php echo $grade; ?>" <?php if(isset($olevel_data[2]) && $olevel_data[2][$subject.'_grade'] == $grade) echo 'selected'; ?>><?php echo $grade; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endforeach; ?>
            </div>

            <input type="submit" value="Submit O'Level Results">
        </form>
    </div>
    <script>
        function showSecondSitting() {
            document.getElementById('second_sitting_form').style.display = 'block';
        }
        if (<?php echo isset($olevel_data[2]) ? 'true' : 'false'; ?>) {
            showSecondSitting();
        }
    </script>
</body>
</html>
