<?php
session_start();
require_once 'database.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $sql = "SELECT id, password, school FROM users WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        if (password_verify($password, $row['password'])) {
            $_SESSION['loggedin'] = true;
            $_SESSION['id'] = $row['id'];
            $_SESSION['school'] = $row['school'];
            header("Location: dashboard.php");
        } else {
            $error = "Invalid password.";
        }
    } else {
        $error = "No user found with that email.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <script src="main.js"></script>
</head>
<body style="background: #f4f6fa; margin: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; justify-content: center;">
    <?php if (isset($error)): ?>
        <script>showAlert('<?php echo $error; ?>');</script>
    <?php endif; ?>
    <?php
        // Determine school for logo (from session, query, or default)
        $schoolParam = isset($_GET['school']) ? strtoupper($_GET['school']) : '';
        $schoolSession = isset($_SESSION['school']) ? strtoupper($_SESSION['school']) : '';
        $school = $schoolParam ?: $schoolSession ?: 'CNS';
    ?>
    <header style="text-align: center; margin-bottom: 1.5em;">
        <div style="display: inline-block; background: #fff; border: 2px solid #e0e4ea; box-shadow: 0 2px 12px rgba(0,0,0,0.06); border-radius: 14px; padding: 1.2em 2em 1em 2em;">
            <img src="img/main.jpeg" alt="National Orthopaedic Hospital Igbobi, Lagos Logo" style="height: 70px; margin-bottom: 0.5em; display: block; margin-left: auto; margin-right: auto;">
            <h1 style="margin-bottom: 0.5em; font-size: 1.35em; color: #1a2a4a; font-weight: 700; letter-spacing: 0.5px;">National Orthopaedic Hospital Igbobi, Lagos</h1>
        </div>
    </header>
    <div style="max-width: 420px; width: 100%; background: #fff; box-shadow: 0 2px 16px rgba(0,0,0,0.08); border-radius: 12px; padding: 2em 1.5em; margin: 0 auto; text-align: center;">
        <div style="display: flex; align-items: center; gap: 1em; justify-content: center; margin-bottom: 1em;">
            <img src="img/<?php echo strtolower($school); ?>.jpeg" alt="<?php echo ($school === 'CNS') ? 'College of Nursing Sciences Logo' : 'Federal College of Orthopaedic Technology Logo'; ?>" id="logo" style="height: 60px;">
            <span style="font-size: 1.2em; font-weight: bold;">
                <?php echo ($school === 'CNS') ? 'College of Nursing Sciences' : 'Federal College of Orthopaedic Technology'; ?>
            </span>
        </div>
        <div class="container" style="text-align: center;">
            <h2 style="margin-top: 0;">Login</h2>
            <form method="post" action="login.php">
                <input type="email" name="email" placeholder="Email" required style="width: 90%; margin-bottom: 1em; padding: 0.7em; border-radius: 6px; border: 1px solid #d0d4e0;">
                <input type="password" name="password" placeholder="Password" required style="width: 90%; margin-bottom: 1em; padding: 0.7em; border-radius: 6px; border: 1px solid #d0d4e0;">
                <input type="submit" value="Login" style="width: 95%; padding: 0.7em; border-radius: 6px; background: #1a2a4a; color: #fff; border: none; font-weight: bold; cursor: pointer;">
            </form>
            <p>Don't have an account? <a href="register.php?school=<?php echo urlencode($school); ?>">Register here</a>.</p>
            <p><a href="forgot_password.php">Forgot your password?</a></p>
            <p><a href="index.php">Back to Homepage</a></p>
            <div class="form-group">
                <label for="school_switch">Switch School:</label>
                <select id="school_switch" onchange="switchSchool()">
                    <option value="CNS" <?php if($school == 'CNS') echo 'selected'; ?>>College of Nursing Sciences</option>
                    <option value="FECOT" <?php if($school == 'FECOT') echo 'selected'; ?>>Federal College of Orthopaedic Technology</option>
                </select>
            </div>
        </div>
    </div>
    <script>
        function switchSchool() {
            var school = document.getElementById("school_switch").value;
            window.location.href = 'login.php?school=' + school;
        }
    </script>
</body>
</html>
