<?php
session_start();
require_once 'database.php';

// Handle school selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['school'])) {
    $_SESSION['school'] = $_POST['school'];
    $school = $_POST['school'];
} else if (isset($_SESSION['school'])) {
    $school = $_SESSION['school'];
} else {
    $school = 'CNS'; // Default
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UTME Application - National Orthopaedic Hospital Igbobi, Lagos</title>
    <link rel="stylesheet" href="style.css">
</head>
<body style="background: linear-gradient(120deg, #e0e7ff 0%, #f4f6fa 100%); margin: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; justify-content: center;">
    <header style="text-align: center; margin-bottom: 2em;">
        <div style="display: inline-block; background: #fff; border: 2px solid #e0e4ea; box-shadow: 0 4px 24px rgba(0,0,0,0.08); border-radius: 18px; padding: 1.7em 2.5em 1.2em 2.5em;">
            <img src="img/main.jpeg" alt="National Orthopaedic Hospital Igbobi, Lagos Logo" style="height: 80px; margin-bottom: 0.7em; display: block; margin-left: auto; margin-right: auto;">
            <h1 style="margin-bottom: 0.7em; font-size: 1.7em; color: #1a2a4a; font-weight: 700; letter-spacing: 0.5px;">National Orthopaedic Hospital Igbobi, Lagos</h1>
        </div>
    </header>
    <div style="max-width: 480px; width: 100%; background: #fff; box-shadow: 0 4px 24px rgba(0,0,0,0.10); border-radius: 16px; padding: 2.5em 2em; margin: 0 auto; text-align: center;">
        <div style="display: flex; align-items: center; gap: 1.2em; justify-content: center; margin-bottom: 1.5em;">
            <img src="img/<?php echo strtolower($school); ?>.jpeg" alt="<?php echo ($school === 'CNS') ? 'College of Nursing Sciences Logo' : 'Federal College of Orthopaedic Technology Logo'; ?>" id="logo" style="height: 70px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.07);">
            <span style="font-size: 1.3em; font-weight: bold; color: #1a2a4a;">
                <?php echo ($school === 'CNS') ? 'College of Nursing Sciences' : 'Federal College of Orthopaedic Technology'; ?>
            </span>
        </div>
        <div class="container" style="text-align: center;">
            <h2 style="margin-top: 0; margin-bottom: 1.2em; font-size: 1.3em; color: #2a3a5a; font-weight: 600;">Welcome to the UTME Application Portal</h2>
            <form method="post" action="index.php" aria-label="School selection" style="margin-bottom: 1.5em;">
                <label for="school" style="font-weight: 500; color: #1a2a4a;">Select your school:</label>
                <select name="school" id="school" onchange="this.form.submit()" aria-describedby="school-desc" style="margin-left: 0.5em; padding: 0.6em 1em; border-radius: 7px; border: 1px solid #d0d4e0; font-size: 1em; background: #f7f8fa; color: #1a2a4a;">
                    <option value="CNS" <?php echo ($school === 'CNS') ? 'selected' : ''; ?>>College of Nursing Sciences</option>
                    <option value="FECOT" <?php echo ($school === 'FECOT') ? 'selected' : ''; ?>>Federal College of Orthopaedic Technology</option>
                </select>
                <span id="school-desc" style="display:none;">Choose your school to update the portal and logo.</span>
            </form>
            <p style="font-size: 1.08em; margin-bottom: 2em; color: #2a3a5a;">Please <a href="login.php?school=<?php echo urlencode($school); ?>" style="color: #1a2a4a; text-decoration: underline; font-weight: 600;">login</a> or <a href="register.php?school=<?php echo urlencode($school); ?>" style="color: #1a2a4a; text-decoration: underline; font-weight: 600;">register</a> to continue.</p>
        </div>
    </div>
    <!-- Logo and school selection now handled server-side for consistency and accessibility -->
</body>
</html>
