<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $institution_name = $_POST['institution_name'];
    $qualification = $_POST['qualification'];
    $from_date = $_POST['from_date'];
    $to_date = $_POST['to_date'];

    $sql = "INSERT INTO education_details (user_id, institution_name, qualification, from_date, to_date) VALUES ('$userid', '$institution_name', '$qualification', '$from_date', '$to_date')";
    $conn->query($sql);

    header("Location: edu_form.php");
}

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $sql = "DELETE FROM education_details WHERE id = $id AND user_id = $userid";
    $conn->query($sql);
    header("Location: edu_form.php");
}

$sql = "SELECT * FROM education_details WHERE user_id = $userid";
$result = $conn->query($sql);
$education_details = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $education_details[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Educational Details - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <script src="main.js"></script>
</head>
<body>
    <header>
        <img src="img/<?php echo $_SESSION['school']; ?>.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
        <?php
            $sql = "SELECT application_no, school FROM applications a JOIN users u ON a.user_id = u.id WHERE u.id = $userid";
            $result = $conn->query($sql);
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                echo "<p>Application Number: <strong>".$row['application_no']."</strong> | School: <strong>".strtoupper($row['school'])."</strong></p>";
            }
        ?>
    </header>
    <div class="container">
        <h2>Educational Details</h2>
        <form method="post" action="edu_form.php" class="edu-form">
            <div class="form-group">
                <label for="institution_name">Name of Institution</label>
                <input type="text" id="institution_name" name="institution_name" placeholder="Name of Institution" required>
            </div>
            <div class="form-group">
                <label for="qualification">Qualification</label>
                <input type="text" id="qualification" name="qualification" placeholder="Qualification" required>
            </div>
            <div class="form-group">
                <label for="from_date">From</label>
                <input type="date" id="from_date" name="from_date" required>
            </div>
            <div class="form-group">
                <label for="to_date">To</label>
                <input type="date" id="to_date" name="to_date" required>
            </div>
            <input type="submit" value="Add Details">
        </form>

        <h3>Your Educational Details</h3>
        <table class="education-table">
            <thead>
                <tr>
                    <th>Institution Name</th>
                    <th>From</th>
                    <th>To</th>
                    <th>Qualification</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($education_details as $detail): ?>
                    <tr>
                        <td><?php echo $detail['institution_name']; ?></td>
                        <td><?php echo $detail['from_date']; ?></td>
                        <td><?php echo $detail['to_date']; ?></td>
                        <td><?php echo $detail['qualification']; ?></td>
                        <td>
                            <a href="edu_form.php?delete=<?php echo $detail['id']; ?>" onclick="return confirm('Are you sure you want to delete this record?');">Remove</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <a href="dashboard.php">Back to Dashboard</a>
    </div>
</body>
</html>
