<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];

// Check form completion status
$application_form_completed = false;
$olevel_form_completed = false;
$edu_form_completed = false;
$payment_completed = false;

// Use prepared statements for security
$stmt = $conn->prepare("SELECT othername FROM users WHERE id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    if (!empty($user['othername'])) {
        $application_form_completed = true;
    }
}
$stmt->close();

$stmt = $conn->prepare("SELECT id FROM olevel_results WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
if ($stmt->get_result()->num_rows > 0) {
    $olevel_form_completed = true;
}
$stmt->close();

$stmt = $conn->prepare("SELECT id FROM education_details WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
if ($stmt->get_result()->num_rows > 0) {
    $edu_form_completed = true;
}
$stmt->close();

$stmt = $conn->prepare("SELECT status FROM applications WHERE user_id = ?");
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $app = $result->fetch_assoc();
    if (in_array(strtolower($app['status']), ['paid', 'completed'])) {
        $payment_completed = true;
    }
}
$stmt->close();

$progress = 0;
if ($application_form_completed) $progress += 25;
if ($olevel_form_completed) $progress += 25;
if ($edu_form_completed) $progress += 25;
if ($payment_completed) $progress += 25;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - UTME Application</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <?php
        $stmt = $conn->prepare("SELECT school, application_no FROM users u JOIN applications a ON u.id = a.user_id WHERE u.id = ?");
        $stmt->bind_param("i", $userid);
        $stmt->execute();
        $result = $stmt->get_result();
        $user_info = $result->fetch_assoc();
        $school = strtoupper($user_info['school'] ?? 'CNS');
        $application_no = $user_info['application_no'] ?? '';
        $stmt->close();
    ?>
    <header>
        <img src="img/main.jpeg" alt="National Orthopaedic Hospital Igbobi, Lagos Logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
    </header>
    <div class="container">
        <h2>Welcome to Your Dashboard</h2>
        <p>Application Number: <strong><?php echo $application_no; ?></strong> | School: <strong><?php echo $school; ?></strong></p>
        
        <div class="progress-bar">
            <div class="progress" style="width: <?php echo $progress; ?>%;"><?php echo $progress; ?>%</div>
        </div>
        
        <ul class="task-list">
            <li>
                <a href="application_form.php">
                    Application Form
                    <?php if ($application_form_completed): ?>
                        <span class="checkmark">✔</span>
                    <?php endif; ?>
                </a>
            </li>
            <li>
                <a href="olevel_form.php">
                    O'Level Results
                    <?php if ($olevel_form_completed): ?>
                        <span class="checkmark">✔</span>
                    <?php endif; ?>
                </a>
            </li>
            <li>
                <a href="edu_form.php">
                    Educational Details
                    <?php if ($edu_form_completed): ?>
                        <span class="checkmark">✔</span>
                    <?php endif; ?>
                </a>
            </li>
            <li>
                <a href="preview.php">
                    Preview Application
                    <?php if ($payment_completed): ?>
                        <span class="checkmark">✔</span>
                    <?php endif; ?>
                </a>
            </li>
        </ul>

        <a href="logout.php" class="btn-logout">Logout</a>
    </div>
</body>
<style>
    .task-list {
        list-style: none;
        padding: 0;
        margin-top: 2rem;
    }
    .task-list li {
        margin-bottom: 1rem;
    }
    .task-list a {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 5px;
        text-decoration: none;
        color: #343a40;
        transition: background-color 0.3s, transform 0.2s;
    }
    .task-list a:hover {
        background-color: #e9ecef;
        transform: translateY(-2px);
    }
    .checkmark {
        color: #28a745;
        font-size: 1.5rem;
        font-weight: bold;
    }
    .btn-logout {
        display: inline-block;
        margin-top: 2rem;
        padding: 10px 20px;
        background-color: #dc3545;
        color: white;
        border-radius: 5px;
        text-decoration: none;
        transition: background-color 0.3s;
    }
    .btn-logout:hover {
        background-color: #c82333;
    }
</style>
</html>
