<?php
session_start();
require_once 'database.php';

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$userid = $_SESSION['id'];
$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $user_data = $result->fetch_assoc();
}
$stmt->close();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $othername = $_POST['othername'];
    $gender = $_POST['gender'];
    $dob = $_POST['dob'];
    $disability = $_POST['disability'];
    $placeOfBirth = $_POST['placeOfBirth'];
    $stateOfOrigin = $_POST['stateOfOrigin'];
    $lga = $_POST['lga'];
    $phonenumber = $_POST['phonenumber'];
    $homeAddress = $_POST['homeAddress'];
    $nextOfKinName = $_POST['nextOfKinName'];
    $nextOfKinGsm = $_POST['nextOfKinGsm'];
    $nextOfKinAddress = $_POST['nextOfKinAddress'];
    $sponsorName = $_POST['sponsorName'];
    $sponsorAddress = $_POST['sponsorAddress'];
    $jambnumber = $_POST['jambnumber'];
    $jambscore = $_POST['jambscore'];
    $programme = $_POST['programme'];
    $session = $_POST['session'];
    $passport_photo = $user_data['passport_photo'];

    if (isset($_FILES['passport_photo']) && $_FILES['passport_photo']['error'] == 0) {
        $target_dir = "uploads/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $target_file = $target_dir . basename($_FILES["passport_photo"]["name"]);
        if (move_uploaded_file($_FILES["passport_photo"]["tmp_name"], $target_file)) {
            $passport_photo = $target_file;
        }
    }

    $sql = "UPDATE users SET othername = ?, gender = ?, dob = ?, disability = ?, placeOfBirth = ?, stateOfOrigin = ?, lga = ?, phonenumber = ?, homeAddress = ?, nextOfKinName = ?, nextOfKinGsm = ?, nextOfKinAddress = ?, sponsorName = ?, sponsorAddress = ?, jambnumber = ?, jambscore = ?, programme = ?, session = ?, passport_photo = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssssssssssssssi", $othername, $gender, $dob, $disability, $placeOfBirth, $stateOfOrigin, $lga, $phonenumber, $homeAddress, $nextOfKinName, $nextOfKinGsm, $nextOfKinAddress, $sponsorName, $sponsorAddress, $jambnumber, $jambscore, $programme, $session, $passport_photo, $userid);

    if ($stmt->execute()) {
        header("Location: dashboard.php");
    } else {
        $error = "Error: " . $sql . "<br>" . $conn->error;
    }
}

$programmes = [
    "FECOT" => [
        "ND POT",
        "HND POT",
        "ND OCT",
        "HND OCT",
        "B.Tech P&O"
    ],
    "CNS" => [
        "ND/HND Nursing Sciences"
    ]
];
// Fetch user's school from database and application number
$userSchool = '';
$application_no = '';
$sql = "SELECT u.school, a.application_no FROM users u LEFT JOIN applications a ON u.id = a.user_id WHERE u.id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userid);
$stmt->execute();
$result = $stmt->get_result();
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $userSchool = strtoupper($row['school']);
    $application_no = $row['application_no'];
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Form - UTME Application</title>
    <link rel="stylesheet" href="style.css">
    <script src="main.js"></script>
</head>
<body>
    <?php if (isset($error)): ?>
        <script>showAlert('<?php echo $error; ?>');</script>
    <?php endif; ?>
    <header>
        <img src="img/<?php echo strtolower($userSchool); ?>.jpeg" alt="School Logo" id="logo">
        <h1>National Orthopaedic Hospital Igbobi, Lagos</h1>
        <?php if (!empty($application_no)): ?>
            <p>Application Number: <strong><?php echo $application_no; ?></strong> | School: <strong><?php echo $userSchool; ?></strong></p>
        <?php endif; ?>
    </header>
<div class="container">
        <h2>POST UTME FORM</h2>
        <form method="post" action="application_form.php" class="utme-form" enctype="multipart/form-data">
            <div class="form-group">
            <label for="passport_photo">Passport Photo <span style="color:red">*</span></label>
            <input type="file" id="passport_photo" name="passport_photo" required accept="image/*">
            <small>Maximum file size: 2MB.</small>
            <?php if (!empty($user_data['passport_photo'])): ?>
                <img src="<?php echo $user_data['passport_photo']; ?>" alt="Passport Photo" width="100">
            <?php endif; ?>
            </div>
            <script>
            document.querySelector('form.utme-form').addEventListener('submit', function(e) {
                const fileInput = document.getElementById('passport_photo');
                if (fileInput.files.length === 0) {
                alert('Passport photo is required.');
                e.preventDefault();
                return;
                }
                if (fileInput.files[0].size > 2 * 1024 * 1024) {
                alert('Passport photo must not be more than 2MB.');
                e.preventDefault();
                }
            });
            </script>
            <div class="form-group">
                <label for="othername">Other Name</label>
                <input type="text" id="othername" name="othername" placeholder="Other Name" value="<?php echo $user_data['othername'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="gender">Gender <span style="color:red">*</span></label>
                <select id="gender" name="gender" required>
                    <option value="">Select Gender</option>
                    <option value="Male" <?php if(isset($user_data['gender']) && $user_data['gender'] == 'Male') echo 'selected'; ?>>Male</option>
                    <option value="Female" <?php if(isset($user_data['gender']) && $user_data['gender'] == 'Female') echo 'selected'; ?>>Female</option>
                </select>
            </div>
            <div class="form-group">
                <label for="dob">Date of Birth <span style="color:red">*</span></label>
                <input type="date" id="dob" name="dob" required value="<?php echo $user_data['dob'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="disability">Disability</label>
                <input type="text" id="disability" name="disability" placeholder="Disability" value="<?php echo $user_data['disability'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="placeOfBirth">Place of Birth <span style="color:red">*</span></label>
                <input type="text" id="placeOfBirth" name="placeOfBirth" placeholder="Place of Birth" required value="<?php echo $user_data['placeOfBirth'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="stateOfOrigin">State of Origin <span style="color:red">*</span></label>
                <select id="stateOfOrigin" name="stateOfOrigin" required>
                    <option value="">Select State</option>
                </select>
            </div>
            <div class="form-group">
                <label for="lga">LGA <span style="color:red">*</span></label>
                <select id="lga" name="lga" required>
                    <option value="">Select LGA</option>
                </select>
            </div>
            <script>
                // Nigerian states and LGAs (sample, add all as needed)
                const statesAndLgas = {
                    "Abia": ["Aba North", "Aba South", "Arochukwu", "Bende", "Ikwuano", "Isiala Ngwa North", "Isiala Ngwa South", "Isuikwuato", "Obi Ngwa", "Ohafia", "Osisioma", "Ugwunagbo", "Ukwa East", "Ukwa West", "Umuahia North", "Umuahia South", "Umu Nneochi"],
                    "Adamawa": ["Demsa", "Fufore", "Ganye", "Girei", "Gombi", "Guyuk", "Hong", "Jada", "Lamurde", "Madagali", "Maiha", "Mayo-Belwa", "Michika", "Mubi North", "Mubi South", "Numan", "Shelleng", "Song", "Toungo", "Yola North", "Yola South"],
                    "Akwa Ibom": ["Abak", "Eastern Obolo", "Eket", "Esit Eket", "Essien Udim", "Etim Ekpo", "Etinan", "Ibeno", "Ibesikpo Asutan", "Ibiono Ibom", "Ikot Abasi", "Ikot Ekpene", "Ini", "Itu", "Mbo", "Mkpat Enin", "Nsit Atai", "Nsit Ibom", "Nsit Ubium", "Obot Akara", "Okobo", "Onna", "Oron", "Oruk Anam", "Udung Uko", "Ukanafun", "Uruan", "Urue-Offong/Oruko", "Uyo"],
                    "Anambra": ["Aguata", "Anambra East", "Anambra West", "Anaocha", "Awka North", "Awka South", "Ayamelum", "Dunukofia", "Ekwusigo", "Idemili North", "Idemili South", "Ihiala", "Njikoka", "Nnewi North", "Nnewi South", "Ogbaru", "Onitsha North", "Onitsha South", "Orumba North", "Orumba South", "Oyi"],
                    "Bauchi": ["Alkaleri", "Bauchi", "Bogoro", "Damban", "Darazo", "Dass", "Gamawa", "Ganjuwa", "Giade", "Itas/Gadau", "Jama'are", "Katagum", "Kirfi", "Misau", "Ningi", "Shira", "Tafawa Balewa", "Toro", "Warji", "Zaki"],
                    "Bayelsa": ["Brass", "Ekeremor", "Kolokuma/Opokuma", "Nembe", "Ogbia", "Sagbama", "Southern Ijaw", "Yenagoa"],
                    "Benue": ["Ado", "Agatu", "Apa", "Buruku", "Gboko", "Guma", "Gwer East", "Gwer West", "Katsina-Ala", "Konshisha", "Kwande", "Logo", "Makurdi", "Obi", "Ogbadibo", "Ohimini", "Oju", "Okpokwu", "Otukpo", "Tarka", "Ukum", "Ushongo", "Vandeikya"],
                    "Borno": ["Abadam", "Askira/Uba", "Bama", "Bayo", "Biu", "Chibok", "Damboa", "Dikwa", "Gubio", "Guzamala", "Gwoza", "Hawul", "Jere", "Kaga", "Kala/Balge", "Konduga", "Kukawa", "Kwaya Kusar", "Mafa", "Magumeri", "Maiduguri", "Marte", "Mobbar", "Monguno", "Ngala", "Nganzai", "Shani"],
                    "Cross River": ["Abi", "Akamkpa", "Akpabuyo", "Bakassi", "Bekwarra", "Biase", "Boki", "Calabar Municipal", "Calabar South", "Etung", "Ikom", "Obanliku", "Obubra", "Obudu", "Odukpani", "Ogoja", "Yakurr", "Yala"],
                    "Delta": ["Aniocha North", "Aniocha South", "Bomadi", "Burutu", "Ethiope East", "Ethiope West", "Ika North East", "Ika South", "Isoko North", "Isoko South", "Ndokwa East", "Ndokwa West", "Okpe", "Oshimili North", "Oshimili South", "Patani", "Sapele", "Udu", "Ughelli North", "Ughelli South", "Ukwuani", "Uvwie", "Warri North", "Warri South", "Warri South West"],
                    "Ebonyi": ["Abakaliki", "Afikpo North", "Afikpo South", "Ebonyi", "Ezza North", "Ezza South", "Ikwo", "Ishielu", "Ivo", "Izzi", "Ohaozara", "Ohaukwu", "Onicha"],
                    "Edo": ["Akoko-Edo", "Egor", "Esan Central", "Esan North-East", "Esan South-East", "Esan West", "Etsako Central", "Etsako East", "Etsako West", "Igueben", "Ikpoba-Okha", "Oredo", "Orhionmwon", "Ovia North-East", "Ovia South-West", "Owan East", "Owan West", "Uhunmwonde"],
                    "Ekiti": ["Ado Ekiti", "Efon", "Ekiti East", "Ekiti South-West", "Ekiti West", "Emure", "Gbonyin", "Ido Osi", "Ijero", "Ikere", "Ikole", "Ilejemeje", "Irepodun/Ifelodun", "Ise/Orun", "Moba", "Oye"],
                    "Enugu": ["Aninri", "Awgu", "Enugu East", "Enugu North", "Enugu South", "Ezeagu", "Igbo Etiti", "Igbo Eze North", "Igbo Eze South", "Isi Uzo", "Nkanu East", "Nkanu West", "Nsukka", "Oji River", "Udenu", "Udi", "Uzo Uwani"],
                    "Gombe": ["Akko", "Balanga", "Billiri", "Dukku", "Funakaye", "Gombe", "Kaltungo", "Kwami", "Nafada", "Shongom", "Yamaltu/Deba"],
                    "Imo": ["Aboh Mbaise", "Ahiazu Mbaise", "Ehime Mbano", "Ezinihitte", "Ideato North", "Ideato South", "Ihitte/Uboma", "Ikeduru", "Isiala Mbano", "Isu", "Mbaitoli", "Ngor Okpala", "Njaba", "Nkwerre", "Nwangele", "Obowo", "Oguta", "Ohaji/Egbema", "Okigwe", "Orlu", "Orsu", "Oru East", "Oru West", "Owerri Municipal", "Owerri North", "Owerri West"],
                    "Jigawa": ["Auyo", "Babura", "Biriniwa", "Birnin Kudu", "Buji", "Dutse", "Gagarawa", "Garki", "Gumel", "Guri", "Gwaram", "Gwiwa", "Hadejia", "Jahun", "Kafin Hausa", "Kazaure", "Kiri Kasama", "Kiyawa", "Maigatari", "Malam Madori", "Miga", "Ringim", "Roni", "Sule Tankarkar", "Taura", "Yankwashi"],
                    "Kaduna": ["Birnin Gwari", "Chikun", "Giwa", "Igabi", "Ikara", "Jaba", "Jema'a", "Kachia", "Kaduna North", "Kaduna South", "Kagarko", "Kajuru", "Kaura", "Kauru", "Kubau", "Kudan", "Lere", "Makarfi", "Sabon Gari", "Sanga", "Soba", "Zangon Kataf", "Zaria"],
                    "Kano": ["Ajingi", "Albasu", "Bagwai", "Bebeji", "Bichi", "Bunkure", "Dala", "Dambatta", "Dawakin Kudu", "Dawakin Tofa", "Doguwa", "Fagge", "Gabasawa", "Garko", "Garun Mallam", "Gaya", "Gezawa", "Gwale", "Gwarzo", "Kabo", "Kano Municipal", "Karaye", "Kibiya", "Kiru", "Kumbotso", "Kunchi", "Kura", "Madobi", "Makoda", "Minjibir", "Nasarawa", "Rano", "Rimin Gado", "Rogo", "Shanono", "Sumaila", "Takai", "Tarauni", "Tofa", "Tsanyawa", "Tudun Wada", "Ungogo", "Warawa", "Wudil"],
                    "Katsina": ["Bakori", "Batagarawa", "Batsari", "Baure", "Bindawa", "Charanchi", "Dandume", "Danja", "Dan Musa", "Daura", "Dutsi", "Dutsin Ma", "Faskari", "Funtua", "Ingawa", "Jibia", "Kafur", "Kaita", "Kankara", "Kankia", "Katsina", "Kurfi", "Kusada", "Mai'Adua", "Malumfashi", "Mani", "Mashi", "Matazu", "Musawa", "Rimi", "Sabuwa", "Safana", "Sandamu", "Zango"],
                    "Kebbi": ["Aleiro", "Arewa Dandi", "Argungu", "Augie", "Bagudo", "Birnin Kebbi", "Bunza", "Dandi", "Fakai", "Gwandu", "Jega", "Kalgo", "Koko/Besse", "Maiyama", "Ngaski", "Sakaba", "Shanga", "Suru", "Yauri", "Zuru"],
                    "Kogi": ["Adavi", "Ajaokuta", "Ankpa", "Bassa", "Dekina", "Ibaji", "Idah", "Igalamela Odolu", "Ijumu", "Kabba/Bunu", "Kogi", "Lokoja", "Mopa-Muro", "Ofu", "Ogori/Magongo", "Okehi", "Okene", "Olamaboro", "Omala", "Yagba East", "Yagba West"],
                    "Kwara": ["Asa", "Baruten", "Edu", "Ekiti", "Ifelodun", "Ilorin East", "Ilorin South", "Ilorin West", "Irepodun", "Isin", "Kaiama", "Moro", "Offa", "Oke Ero", "Oyun", "Pategi"],
                    "Lagos": ["Agege", "Ajeromi-Ifelodun", "Alimosho", "Amuwo-Odofin", "Apapa", "Badagry", "Epe", "Eti-Osa", "Ibeju-Lekki", "Ifako-Ijaiye", "Ikeja", "Ikorodu", "Kosofe", "Lagos Island", "Lagos Mainland", "Mushin", "Ojo", "Oshodi-Isolo", "Shomolu", "Surulere"],
                    "Nasarawa": ["Akwanga", "Awe", "Doma", "Karu", "Keana", "Keffi", "Kokona", "Lafia", "Nasarawa", "Nasarawa Egon", "Obi", "Toto", "Wamba"],
                    "Niger": ["Agaie", "Agwara", "Bida", "Borgu", "Bosso", "Chanchaga", "Edati", "Gbako", "Gurara", "Katcha", "Kontagora", "Lapai", "Lavun", "Magama", "Mariga", "Mashegu", "Mokwa", "Muya", "Paikoro", "Rafi", "Rijau", "Shiroro", "Suleja", "Tafa", "Wushishi"],
                    "Ogun": ["Abeokuta North", "Abeokuta South", "Ado-Odo/Ota", "Egbado North", "Egbado South", "Ewekoro", "Ifo", "Ijebu East", "Ijebu North", "Ijebu North East", "Ijebu Ode", "Ikenne", "Imeko Afon", "Ipokia", "Obafemi Owode", "Odeda", "Odogbolu", "Ogun Waterside", "Remo North", "Sagamu"],
                    "Ondo": ["Akoko North-East", "Akoko North-West", "Akoko South-East", "Akoko South-West", "Akure North", "Akure South", "Ese Odo", "Idanre", "Ifedore", "Ilaje", "Ile Oluji/Okeigbo", "Irele", "Odigbo", "Okitipupa", "Ondo East", "Ondo West", "Ose", "Owo"],
                    "Osun": ["Aiyedaade", "Aiyedire", "Atakunmosa East", "Atakunmosa West", "Boluwaduro", "Boripe", "Ede North", "Ede South", "Egbedore", "Ejigbo", "Ife Central", "Ife East", "Ife North", "Ife South", "Ifedayo", "Ifelodun", "Ila", "Ilesa East", "Ilesa West", "Irepodun", "Irewole", "Isokan", "Iwo", "Obokun", "Odo Otin", "Ola Oluwa", "Olorunda", "Oriade", "Orolu", "Osogbo"],
                    "Oyo": ["Afijio", "Akinyele", "Atiba", "Atisbo", "Egbeda", "Ibadan North", "Ibadan North-East", "Ibadan North-West", "Ibadan South-East", "Ibadan South-West", "Ibarapa Central", "Ibarapa East", "Ibarapa North", "Ido", "Irepo", "Iseyin", "Itesiwaju", "Iwajowa", "Kajola", "Lagelu", "Ogbomosho North", "Ogbomosho South", "Ogo Oluwa", "Olorunsogo", "Oluyole", "Ona Ara", "Orelope", "Ori Ire", "Oyo East", "Oyo West", "Saki East", "Saki West", "Surulere"],
                    "Plateau": ["Barkin Ladi", "Bassa", "Bokkos", "Jos East", "Jos North", "Jos South", "Kanam", "Kanke", "Langtang North", "Langtang South", "Mangu", "Mikang", "Pankshin", "Qua'an Pan", "Riyom", "Shendam", "Wase"],
                    "Rivers": ["Abua/Odual", "Ahoada East", "Ahoada West", "Akuku-Toru", "Andoni", "Asari-Toru", "Bonny", "Degema", "Eleme", "Emohua", "Etche", "Gokana", "Ikwerre", "Khana", "Obio/Akpor", "Ogba/Egbema/Ndoni", "Ogu/Bolo", "Okrika", "Omuma", "Opobo/Nkoro", "Oyigbo", "Port Harcourt", "Tai"],
                    "Sokoto": ["Binji", "Bodinga", "Dange Shuni", "Gada", "Goronyo", "Gudu", "Gwadabawa", "Illela", "Isa", "Kebbe", "Kware", "Rabah", "Sabon Birni", "Shagari", "Silame", "Sokoto North", "Sokoto South", "Tambuwal", "Tangaza", "Tureta", "Wamako", "Wurno", "Yabo"],
                    "Taraba": ["Ardo Kola", "Bali", "Donga", "Gashaka", "Gassol", "Ibi", "Jalingo", "Karim Lamido", "Kurmi", "Lau", "Sardauna", "Takum", "Ussa", "Wukari", "Yorro", "Zing"],
                    "Yobe": ["Bade", "Bursari", "Damaturu", "Fika", "Fune", "Geidam", "Gujba", "Gulani", "Jakusko", "Karasuwa", "Machina", "Nangere", "Nguru", "Potiskum", "Tarmuwa", "Yunusari", "Yusufari"],
                    "Zamfara": ["Anka", "Bakura", "Birnin Magaji/Kiyaw", "Bukkuyum", "Bungudu", "Gummi", "Gusau", "Kaura Namoda", "Maradun", "Maru", "Shinkafi", "Talata Mafara", "Tsafe", "Zurmi"]
                };

                // Populate states dropdown
                const stateSelect = document.getElementById('stateOfOrigin');
                const lgaSelect = document.getElementById('lga');
                const selectedState = "<?php echo $user_data['stateOfOrigin'] ?? ''; ?>";
                const selectedLga = "<?php echo $user_data['lga'] ?? ''; ?>";

                function populateStates() {
                    Object.keys(statesAndLgas).forEach(state => {
                        const option = document.createElement('option');
                        option.value = state;
                        option.textContent = state;
                        if (state === selectedState) option.selected = true;
                        stateSelect.appendChild(option);
                    });
                }

                function populateLgas(state) {
                    lgaSelect.innerHTML = '<option value="">Select LGA</option>';
                    if (statesAndLgas[state]) {
                        statesAndLgas[state].forEach(lga => {
                            const option = document.createElement('option');
                            option.value = lga;
                            option.textContent = lga;
                            if (lga === selectedLga) option.selected = true;
                            lgaSelect.appendChild(option);
                        });
                    }
                }

                stateSelect.addEventListener('change', function() {
                    populateLgas(this.value);
                });

                // Initial population
                populateStates();
                if (selectedState) {
                    populateLgas(selectedState);
                }
            </script>
            <div class="form-group">
                <label for="phonenumber">Phone Number</label>
                <input type="tel" id="phonenumber" name="phonenumber" placeholder="Phone Number" required pattern="\d{11}" maxlength="11" minlength="11" value="<?php echo $user_data['phonenumber'] ?? ''; ?>">
                <small>Phone number must be 11 digits.</small>
            </div>
            <div class="form-group">
                <label for="homeAddress">Home Address</label>
                <textarea id="homeAddress" name="homeAddress" placeholder="Home Address"><?php echo $user_data['homeAddress'] ?? ''; ?></textarea>
            </div>
            <div class="form-group">
                <label for="nextOfKinName">Next of Kin Name <span style="color:red">*</span></label>
                <input type="text" id="nextOfKinName" name="nextOfKinName" placeholder="Next of Kin Name" required value="<?php echo $user_data['nextOfKinName'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="nextOfKinGsm">Next of Kin GSM <span style="color:red">*</span></label>
                <input type="tel" id="nextOfKinGsm" name="nextOfKinGsm" placeholder="Next of Kin GSM" required value="<?php echo $user_data['nextOfKinGsm'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="nextOfKinAddress">Next of Kin Address <span style="color:red">*</span></label>
                <textarea id="nextOfKinAddress" name="nextOfKinAddress" placeholder="Next of Kin Address" required><?php echo $user_data['nextOfKinAddress'] ?? ''; ?></textarea>
            </div>
            <div class="form-group">
                <label for="sponsorName">Sponsor Name</label>
                <input type="text" id="sponsorName" name="sponsorName" placeholder="Sponsor Name" value="<?php echo $user_data['sponsorName'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="sponsorAddress">Sponsor Address</label>
                <textarea id="sponsorAddress" name="sponsorAddress" placeholder="Sponsor Address"><?php echo $user_data['sponsorAddress'] ?? ''; ?></textarea>
            </div>
            <div class="form-group">
                <label for="jambnumber">JAMB Number <span style="color:red">*</span></label>
                <input type="text" id="jambnumber" name="jambnumber" placeholder="JAMB Number" required maxlength="10" minlength="10" value="<?php echo $user_data['jambnumber'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="jambscore">JAMB Score <span style="color:red">*</span></label>
                <input type="number" id="jambscore" name="jambscore" placeholder="JAMB Score" required min="0" max="400" value="<?php echo $user_data['jambscore'] ?? ''; ?>">
            </div>
            <div class="form-group">
                <label for="programme">Programme <span style="color:red">*</span></label>
                <select name="programme" id="programme" required>
                    <option value="">Select Program</option>
                </select>
            </div>
            <div class="form-group">
                <label for="session">Session</label>
                <input type="text" id="session" name="session" value="<?php echo $user_data['session'] ?? date('Y') . '/' . (date('Y') + 1); ?>" readonly>
            </div>
            <input type="submit" value="Submit Application">
            <a href="dashboard.php" class="btn-cancel" onclick="return confirm('Are you sure you want to cancel? Any unsaved changes will be lost.');">Cancel</a>
        </form>
    </div>
    <script>
        const programmes = <?php echo json_encode($programmes); ?>;
        const school = "<?php echo $userSchool; ?>";
        const selectedProgramme = "<?php echo $user_data['programme'] ?? ''; ?>";

        function updateProgrammes() {
            const programmeSelect = document.getElementById('programme');
            programmeSelect.innerHTML = '<option value="">Select Program</option>';

            if (programmes[school]) {
                programmes[school].forEach(programme => {
                    const option = document.createElement('option');
                    option.value = programme;
                    option.textContent = programme;
                    if (programme === selectedProgramme) {
                        option.selected = true;
                    }
                    programmeSelect.appendChild(option);
                });
            }
        }
        
        updateProgrammes();
    </script>
</body>
</html>


